<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Admin extends Eloquent {

	protected $table = 'admins';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function roles()
	{
		return $this->morphToMany('Role');
	}

	public function admin_meta()
	{
		return $this->hasMany('AdminMeta');
	}

}