<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderProductReletion extends Eloquent {

	protected $table = 'order_product_reletion';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function products()
	{
		return $this->belongsToMany('Product');
	}

	public function order()
	{
		return $this->belongsToMany('Role');
	}

}