<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function roles()
    {
        return $this->morphToMany('Role');
    }

    public function user_meta()
    {
        return $this->hasMany('UserMeta');
    }

    public function address()
    {
        return $this->hasMany('UserAddress');
    }

    public function orders()
    {
        return $this->hasMany('Order');
    }

}