<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCashCollectionsTable extends Migration {

	public function up()
	{
		Schema::create('cash_collections', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id');
			$table->bigInteger('order_id');
			$table->string('latitude');
			$table->string('longitude');
			$table->bigInteger('wallet_id');
			$table->decimal('payment');
			$table->decimal('amount');
			$table->decimal('change');
		});
	}

	public function down()
	{
		Schema::drop('cash_collections');
	}
}