<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReportsTable extends Migration {

	public function up()
	{
		Schema::create('reports', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('helpdesk_id')->unsigned()->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('referrer_id')->unsigned()->nullable();
			$table->string('referrer_name', 255)->nullable();
			$table->string('referrer_position', 255)->nullable();
			$table->string('referrer_tel', 255)->nullable();
			$table->integer('client_id')->unsigned()->nullable();
			$table->integer('practitioner_id')->unsigned()->nullable();
			$table->text('reason_report')->nullable();
			$table->integer('urgency_id')->unsigned()->nullable();
			$table->text('deviation_urgency')->nullable();
			$table->text('history_psychiatric')->nullable();
			$table->text('history_somatic')->nullable();
			$table->text('history_psychotropics')->nullable();
			$table->integer('agression_id')->nullable();
			$table->text('aggression_desc')->nullable();
			$table->integer('addiction_id')->nullable();
			$table->text('addiction_desc')->nullable();
			$table->integer('children_id')->nullable();
			$table->text('children_desc')->nullable();
			$table->integer('suicidality_id')->nullable();
			$table->text('suicidality_desc')->nullable();
			$table->integer('psychotic_problems_id')->nullable();
			$table->text('psychotic_desc')->nullable();
			$table->integer('judicial_past_id')->nullable();
			$table->text('judicial_past_desc')->nullable();
			$table->boolean('substances_use')->nullable();
			$table->integer('substances_id')->nullable();
			$table->string('substances_additional', 255)->nullable();
			$table->integer('zm_id')->nullable();
			$table->text('zm_desc')->nullable();
			$table->integer('caretaker_id')->nullable();
			$table->integer('transportation_id')->nullable();
			$table->integer('policy_triage_id')->unsigned()->nullable();
			$table->text('motivation_triage')->nullable();
			$table->integer('status_id')->unsigned()->nullable();
			$table->integer('consult_type_id')->unsigned()->nullable();
			$table->integer('consult_id')->nullable();
			$table->integer('employee1')->unsigned();
			$table->integer('employee2')->unsigned();
			$table->datetime('updated_at');
			$table->datetime('created_at');
			$table->integer('inspect_user_id')->unsigned()->nullable()->default('NULL');
			$table->bigInteger('group_report_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('reports');
	}
}