<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalEntitiesTable extends Migration {

	public function up()
	{
		Schema::create('legal_entities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('pib')->nullable();
			$table->string('contact_person')->nullable();
			$table->string('address')->nullable();
			$table->integer('city_id')->unsigned();
			$table->string('pdv')->nullable();
			$table->string('phone_number')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('legal_entities');
	}
}