<?php

namespace EmitentContentTranslation;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmitentContentTranslation extends Model 
{

    protected $table = 'emitent_content_translations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function language()
    {
        return $this->belongsTo('Language', 'language_id');
    }

    public function emitent()
    {
        return $this->belongsTo('EmitentContent', 'emitent_content_id');
    }

}