<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('news_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('news_id')->unsigned();
			$table->integer('language_id')->unsigned();
			$table->string('title');
			$table->text('text');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('news_translations');
	}
}