<?php

namespace CityTransaltion;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CityTransaltion extends Eloquent {

	protected $table = 'cities_translations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function language()
	{
		return $this->belongsTo('Language', 'language_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

}