<?php

namespace Emitent;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Emitent extends Eloquent {

	protected $table = 'emitents';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->morphMany('User', 'userable');
	}

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function category()
	{
		return $this->belongsTo('EmitentCategory');
	}

	public function images()
	{
		return $this->morphMany('Image', 'imageable');
	}

}