<?php

namespace FaqsTransaltion;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FaqsTransaltion extends Eloquent {

	protected $table = 'faqs_translations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function language()
	{
		return $this->belongsTo('Language', 'language_id');
	}

	public function faq()
	{
		return $this->belongsTo('Faq', 'faq_id');
	}

}