<?php

namespace PhysicalInstructionsTranslation;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PhysicalInstructionsTranslation extends Eloquent {

	protected $table = 'physical_insts_translations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function physicalInstruction()
	{
		return $this->belongsTo('PhysicalInstruction');
	}

	public function language()
	{
		return $this->belongsTo('Language', 'language_id');
	}

}