<?php

namespace UserVoucher;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserVoucher extends Eloquent {

	protected $table = 'user_vouchers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function voucher()
	{
		return $this->belongsTo('Voucher', 'voucher_id');
	}

}