<?php

namespace CountryTranslation;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CountryTranslation extends Eloquent {

	protected $table = 'countries_translations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function language()
	{
		return $this->belongsTo('Language', 'language_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}