<?php

namespace HomepageCardTranslation;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class HomepageCardTranslation extends Eloquent {

	protected $table = 'homepage_cards_translations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function language()
	{
		return $this->belongsTo('Language', 'language_id');
	}

	public function homepageCard()
	{
		return $this->belongsTo('HomepageCard', 'homepage_card_id');
	}

}