<?php

namespace LegalEntity;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LegalEntity extends Eloquent {

	protected $table = 'legal_entities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->morphMany('User', 'userable');
	}

	public function city()
	{
		return $this->belongsTo('City');
	}

}