<?php

namespace NewsTranslation;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class NewsTranslation extends Eloquent {

	protected $table = 'news_translations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function news()
	{
		return $this->belongsTo('News', 'news_id');
	}

	public function language()
	{
		return $this->belongsTo('Language', 'language_id');
	}

}