<?php

namespace PhysicalEntity;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PhysicalEntity extends Eloquent {

	protected $table = 'physical_entities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->morphMany('User', 'userable');
	}

	public function city()
	{
		return $this->belongsTo('City');
	}

}