<?php

namespace Voucher;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Voucher extends Eloquent {

	protected $table = 'vouchers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function status()
	{
		return $this->belongsTo('VoucherStatus', 'status_id');
	}

	public function emitent()
	{
		return $this->belongsTo('User', 'emitent_id');
	}

	public function type()
	{
		return $this->belongsTo('UserVoucherType', 'user_voucher_type_id');
	}

}