<?php

namespace LegalEntity;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LegalEntity extends Model 
{

    protected $table = 'legal_entities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->morphMany('User', 'userable');
    }

    public function city()
    {
        return $this->belongsTo('City');
    }

}