<?php

namespace PhysicalInstructionsTranslation;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PhysicalInstructionsTranslation extends Model 
{

    protected $table = 'physical_insts_translations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function physicalInstruction()
    {
        return $this->belongsTo('PhysicalInstruction');
    }

    public function language()
    {
        return $this->belongsTo('Language', 'language_id');
    }

}