<?php

namespace UserVoucherType;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserVoucherType extends Model 
{

    protected $table = 'user_voucher_types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User', 'userable');
    }

    public function type()
    {
        return $this->belongsTo('VoucherType', 'voucher_type_id');
    }

}