<?php

namespace FaqsTransaltion;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FaqsTransaltion extends Model 
{

    protected $table = 'faqs_translations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function language()
    {
        return $this->belongsTo('Language', 'language_id');
    }

    public function faq()
    {
        return $this->belongsTo('Faq', 'faq_id');
    }

}