<?php

namespace NewsTranslation;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NewsTranslation extends Model 
{

    protected $table = 'news_translations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function news()
    {
        return $this->belongsTo('News', 'news_id');
    }

    public function language()
    {
        return $this->belongsTo('Language', 'language_id');
    }

}