<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Address extends Model 
{

    protected $table = 'address';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'name', 'city', 'address', 'longitude', 'latitude', 'phone_number', 'is_primary');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}