<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class VendorCategory extends Model 
{

    protected $table = 'vendor_category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('vendor_id', 'category_id', 'status');

    public function vendor()
    {
        return $this->belongsTo('Vendor', 'vendor_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

}