<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryTable extends Migration {

	public function up()
	{
		Schema::create('category', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('status', 100)->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->boolean('reservation')->nullable();
			$table->boolean('order_service')->nullable();
			$table->boolean('multi')->nullable();
			$table->boolean('has_description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('category');
	}
}