<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationTable extends Migration {

	public function up()
	{
		Schema::create('notification', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->string('title_en')->nullable();
			$table->string('title_ar')->nullable();
			$table->string('message_en')->nullable();
			$table->string('message_ar')->nullable();
			$table->string('type', 100)->nullable();
			$table->boolean('is_read')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('notification');
	}
}