<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderPatient extends Eloquent {

	protected $table = 'order_patient';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'patient_id');

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

	public function patient()
	{
		return $this->belongsTo('Patient', 'patient_id');
	}

}