<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payment extends Eloquent {

	protected $table = 'payment';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'order_id', 'transaction_id', 'amount', 'status');

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}