<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class VendorCategory extends Eloquent {

	protected $table = 'vendor_category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('vendor_id', 'category_id', 'status');

	public function vendor()
	{
		return $this->belongsTo('Vendor', 'vendor_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}