<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class VendorService extends Eloquent {

	protected $table = 'vendor_service';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('vendor_id', 'service_id', 'price', 'status');

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

	public function vendor()
	{
		return $this->belongsTo('Vendor', 'vendor_id');
	}

}