<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorTable extends Migration {

	public function up()
	{
		Schema::create('doctor', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('phone')->nullable();
			$table->integer('vendor_id')->nullable();
			$table->integer('service_id')->nullable();
			$table->integer('classification_id')->nullable();
			$table->text('biography')->nullable();
			$table->smallInteger('experience')->nullable();
			$table->text('license')->nullable();
			$table->double('home_visit_price')->nullable();
			$table->double('hospital_price')->nullable();
			$table->string('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('doctor');
	}
}