<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Review extends Eloquent {

	protected $table = 'review';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'vendor_id', 'user_id', 'rating', 'review_en', 'review_ar');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function vendor()
	{
		return $this->belongsTo('Vendor', 'vendor_id');
	}

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

}