<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Slot extends Eloquent {

	protected $table = 'slot';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('date', 'hour', 'duration', 'reserved', 'category_id', 'doctor_id', 'service_id', 'vendor_id');

	public function vendor()
	{
		return $this->belongsTo('Vendor', 'vendor_id');
	}

	public function doctor()
	{
		return $this->belongsTo('Doctor', 'doctor_id');
	}

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}