<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Notification extends Model 
{

    protected $table = 'notification';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'title_en', 'title_ar', 'message_en', 'message_ar', 'type', 'is_read');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}