<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment extends Model 
{

    protected $table = 'payment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'order_id', 'transaction_id', 'amount', 'status');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}