<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSlotTable extends Migration {

	public function up()
	{
		Schema::create('slot', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->datetime('date')->nullable();
			$table->string('hour')->nullable();
			$table->integer('duration')->nullable();
			$table->boolean('reserved')->nullable();
			$table->integer('category_id')->nullable();
			$table->integer('doctor_id')->nullable();
			$table->integer('service_id')->nullable();
			$table->integer('vendor_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('slot');
	}
}