<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressTable extends Migration {

	public function up()
	{
		Schema::create('address', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('user_id')->nullable();
			$table->string('name')->nullable();
			$table->text('city')->nullable();
			$table->text('address')->nullable();
			$table->double('longitude')->nullable();
			$table->double('latitude')->nullable();
			$table->string('phone_number')->nullable();
			$table->boolean('is_primary')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('address');
	}
}