<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlentyOrderAmountVatTable extends Migration {

	public function up()
	{
		Schema::create('plenty_order_amount_vat', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('orderAmountId')->unsigned()->index();
			$table->integer('countryVatId')->unsigned();
			$table->integer('vatId')->unsigned();
			$table->decimal('vatAmount', 4,2);
			$table->decimal('value', 13,4);
			$table->timestamps();
			$table->timestamp('createdAt');
		});
	}

	public function down()
	{
		Schema::drop('plenty_order_amount_vat');
	}
}