<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlentyOrderPositionTable extends Migration {

	public function up()
	{
		Schema::create('plenty_order_position', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('orderId')->unsigned()->index();
			$table->integer('typeId')->unsigned()->index();
			$table->decimal('referrer', 5,2)->index()->default('0');
			$table->integer('variationId')->unsigned()->index();
			$table->decimal('variationQuantity', 8,2);
			$table->string('varitionName', 256);
			$table->string('attributeValues', 256);
			$table->string('characterValues', 256);
			$table->string('shippingProfil_xxx');
			$table->integer('warehouseId_xxxx')->unsigned()->index();
			$table->timestamps();
			$table->timestamp('createdAt');
		});
	}

	public function down()
	{
		Schema::drop('plenty_order_position');
	}
}