<?php

namespace Plenty\Modules\Order\Models;

class Order extends Eloquent {

	protected $table = 'plenty_order';
	public $timestamps = false;
	protected $fillable = array('typeId', 'plentyId', 'methodOfPayment', 'statusId', 'shippingProfile', 'ownerId');
	protected $visible = array('typeId', 'plentyId', 'methodOfPayment', 'statusId', 'shippingProfile', 'ownerId', 'updatedAt', 'createdAt');

	public function amounts()
	{
		return $this->hasMany('OrderAmount', 'orderId', 'id');
	}

	public function type()
	{
		return $this->hasOne('OrderType', 'id', 'typeId');
	}

	public function orderPositions()
	{
		return $this->hasMany('OrderPosition', 'id', 'orderId');
	}

	public function dateOptions()
	{
		return $this->hasMany('OrderDateOption', 'orderId', 'id');
	}

	public function status()
	{
		return $this->hasOne('OrderStatus', 'id', 'statusId');
	}

	public function options()
	{
		return $this->hasMany('OrderOption', 'orderId', 'id');
	}

	public function childReferences()
	{
		return $this->hasMany('OrderReference', 'orderId', 'id');
	}

	public function parentReferences()
	{
		return $this->hasMany('OrderReference', 'referenceOrder', 'id');
	}

	public function events()
	{
		return $this->hasMany('OrderEvent', 'orderId', 'id');
	}

}