<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlentyOrderReferenceTable extends Migration {

	public function up()
	{
		Schema::create('plenty_order_reference', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('orderId')->unsigned()->index();
			$table->integer('referenceOrder')->unsigned()->index();
			$table->tinyInteger('isParent')->unsigned()->default('1');
			$table->timestamp('createdAt');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('plenty_order_reference');
	}
}