<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id');
			$table->string('sap_number');
			$table->string('b2b_number');
			$table->integer('status');
			$table->float('total_amount');
			$table->float('shipping_costs');
			$table->mediumText('address');
			$table->string('postal_code');
			$table->string('city');
			$table->string('country');
			$table->string('phone');
			$table->datetime('registered_at');
			$table->datetime('delivery_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}