<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TitleApplicant extends Model 
{

    protected $table = 'title_applicants';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function applicant()
    {
        return $this->hasMany('Applicant', 'applicant_id');
    }

    public function title()
    {
        return $this->hasMany('Title', 'title_id');
    }

}