<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidaciesTable extends Migration {

	public function up()
	{
		Schema::create('candidacies', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('date')->nullable()->index();
			$table->enum('processing_step', array('Nouveau', 'Àtraiter', 'Traité', 'Encours'));
			$table->boolean('archive');
			$table->text('comment')->nullable()->default('NULL');
			$table->integer('offer_id')->unsigned()->nullable()->index();
			$table->integer('applicant_id')->unsigned()->nullable()->default('NULL');
			$table->integer('third_id')->unsigned()->default('NULL');
			$table->integer('agent_id')->unsigned()->nullable()->default('NULL');
			$table->timestamps();
			$table->tinyInteger('email_send')->default('0');
			$table->softDeletes();
			$table->tinyInteger('applicant')->default('0');
			$table->tinyInteger('third')->default('0');
			$table->tinyInteger('jury_convocation')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('candidacies');
	}
}