<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CandidacyService extends Model 
{

    protected $table = 'candidacy_services';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function candidacy()
    {
        return $this->hasMany('Candidacy', 'candidacy_id');
    }

    public function service()
    {
        return $this->hasMany('Service', 'service_id');
    }

}