<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonsTable extends Migration {

	public function up()
	{
		Schema::create('persons', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('civility', array('Madame', 'Monsieur', 'Société', 'Collectivité', 'Autre'));
			$table->string('name', 128)->nullable()->index();
			$table->string('firstname', 128)->nullable()->index();
			$table->string('email', 255)->nullable();
			$table->string('address_1', 255)->nullable()->index();
			$table->string('address_2', 255)->nullable();
			$table->string('address_3', 255)->nullable();
			$table->smallInteger('zip_code')->nullable()->index();
			$table->string('city', 255)->nullable();
			$table->integer('phone_1')->nullable()->index();
			$table->integer('phone_2')->nullable()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('persons');
	}
}