<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CandidacyService extends Eloquent {

	protected $table = 'candidacy_services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function candidacy()
	{
		return $this->hasMany('Candidacy', 'candidacy_id');
	}

	public function service()
	{
		return $this->hasMany('Service', 'service_id');
	}

}