<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TitleApplicant extends Eloquent {

	protected $table = 'title_applicants';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function applicant()
	{
		return $this->hasMany('Applicant', 'applicant_id');
	}

	public function title()
	{
		return $this->hasMany('Title', 'title_id');
	}

}